<?php
/**
 * FormStyle
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Marketing\Forms
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Forms
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v3
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Marketing\Forms\Model;

use \ArrayAccess;
use \HubSpot\Client\Marketing\Forms\ObjectSerializer;

/**
 * FormStyle Class Doc Comment
 *
 * @category Class
 * @description Styling options for the form
 * @package  HubSpot\Client\Marketing\Forms
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class FormStyle implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'FormStyle';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'label_text_size' => 'string',
        'legal_consent_text_color' => 'string',
        'font_family' => 'string',
        'legal_consent_text_size' => 'string',
        'background_width' => 'string',
        'help_text_size' => 'string',
        'submit_font_color' => 'string',
        'label_text_color' => 'string',
        'submit_alignment' => 'string',
        'submit_size' => 'string',
        'help_text_color' => 'string',
        'submit_color' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'label_text_size' => null,
        'legal_consent_text_color' => null,
        'font_family' => null,
        'legal_consent_text_size' => null,
        'background_width' => null,
        'help_text_size' => null,
        'submit_font_color' => null,
        'label_text_color' => null,
        'submit_alignment' => null,
        'submit_size' => null,
        'help_text_color' => null,
        'submit_color' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'label_text_size' => false,
        'legal_consent_text_color' => false,
        'font_family' => false,
        'legal_consent_text_size' => false,
        'background_width' => false,
        'help_text_size' => false,
        'submit_font_color' => false,
        'label_text_color' => false,
        'submit_alignment' => false,
        'submit_size' => false,
        'help_text_color' => false,
        'submit_color' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'label_text_size' => 'labelTextSize',
        'legal_consent_text_color' => 'legalConsentTextColor',
        'font_family' => 'fontFamily',
        'legal_consent_text_size' => 'legalConsentTextSize',
        'background_width' => 'backgroundWidth',
        'help_text_size' => 'helpTextSize',
        'submit_font_color' => 'submitFontColor',
        'label_text_color' => 'labelTextColor',
        'submit_alignment' => 'submitAlignment',
        'submit_size' => 'submitSize',
        'help_text_color' => 'helpTextColor',
        'submit_color' => 'submitColor'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'label_text_size' => 'setLabelTextSize',
        'legal_consent_text_color' => 'setLegalConsentTextColor',
        'font_family' => 'setFontFamily',
        'legal_consent_text_size' => 'setLegalConsentTextSize',
        'background_width' => 'setBackgroundWidth',
        'help_text_size' => 'setHelpTextSize',
        'submit_font_color' => 'setSubmitFontColor',
        'label_text_color' => 'setLabelTextColor',
        'submit_alignment' => 'setSubmitAlignment',
        'submit_size' => 'setSubmitSize',
        'help_text_color' => 'setHelpTextColor',
        'submit_color' => 'setSubmitColor'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'label_text_size' => 'getLabelTextSize',
        'legal_consent_text_color' => 'getLegalConsentTextColor',
        'font_family' => 'getFontFamily',
        'legal_consent_text_size' => 'getLegalConsentTextSize',
        'background_width' => 'getBackgroundWidth',
        'help_text_size' => 'getHelpTextSize',
        'submit_font_color' => 'getSubmitFontColor',
        'label_text_color' => 'getLabelTextColor',
        'submit_alignment' => 'getSubmitAlignment',
        'submit_size' => 'getSubmitSize',
        'help_text_color' => 'getHelpTextColor',
        'submit_color' => 'getSubmitColor'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const SUBMIT_ALIGNMENT_LEFT = 'left';
    public const SUBMIT_ALIGNMENT_RIGHT = 'right';
    public const SUBMIT_ALIGNMENT_CENTER = 'center';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getSubmitAlignmentAllowableValues()
    {
        return [
            self::SUBMIT_ALIGNMENT_LEFT,
            self::SUBMIT_ALIGNMENT_RIGHT,
            self::SUBMIT_ALIGNMENT_CENTER,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->setIfExists('label_text_size', $data ?? [], null);
        $this->setIfExists('legal_consent_text_color', $data ?? [], null);
        $this->setIfExists('font_family', $data ?? [], null);
        $this->setIfExists('legal_consent_text_size', $data ?? [], null);
        $this->setIfExists('background_width', $data ?? [], null);
        $this->setIfExists('help_text_size', $data ?? [], null);
        $this->setIfExists('submit_font_color', $data ?? [], null);
        $this->setIfExists('label_text_color', $data ?? [], null);
        $this->setIfExists('submit_alignment', $data ?? [], null);
        $this->setIfExists('submit_size', $data ?? [], null);
        $this->setIfExists('help_text_color', $data ?? [], null);
        $this->setIfExists('submit_color', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['label_text_size'] === null) {
            $invalidProperties[] = "'label_text_size' can't be null";
        }
        if ($this->container['legal_consent_text_color'] === null) {
            $invalidProperties[] = "'legal_consent_text_color' can't be null";
        }
        if ($this->container['font_family'] === null) {
            $invalidProperties[] = "'font_family' can't be null";
        }
        if ($this->container['legal_consent_text_size'] === null) {
            $invalidProperties[] = "'legal_consent_text_size' can't be null";
        }
        if ($this->container['background_width'] === null) {
            $invalidProperties[] = "'background_width' can't be null";
        }
        if ($this->container['help_text_size'] === null) {
            $invalidProperties[] = "'help_text_size' can't be null";
        }
        if ($this->container['submit_font_color'] === null) {
            $invalidProperties[] = "'submit_font_color' can't be null";
        }
        if ($this->container['label_text_color'] === null) {
            $invalidProperties[] = "'label_text_color' can't be null";
        }
        if ($this->container['submit_alignment'] === null) {
            $invalidProperties[] = "'submit_alignment' can't be null";
        }
        $allowedValues = $this->getSubmitAlignmentAllowableValues();
        if (!is_null($this->container['submit_alignment']) && !in_array($this->container['submit_alignment'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'submit_alignment', must be one of '%s'",
                $this->container['submit_alignment'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['submit_size'] === null) {
            $invalidProperties[] = "'submit_size' can't be null";
        }
        if ($this->container['help_text_color'] === null) {
            $invalidProperties[] = "'help_text_color' can't be null";
        }
        if ($this->container['submit_color'] === null) {
            $invalidProperties[] = "'submit_color' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets label_text_size
     *
     * @return string
     */
    public function getLabelTextSize()
    {
        return $this->container['label_text_size'];
    }

    /**
     * Sets label_text_size
     *
     * @param string $label_text_size 
     *
     * @return self
     */
    public function setLabelTextSize($label_text_size)
    {
        if (is_null($label_text_size)) {
            throw new \InvalidArgumentException('non-nullable label_text_size cannot be null');
        }
        $this->container['label_text_size'] = $label_text_size;

        return $this;
    }

    /**
     * Gets legal_consent_text_color
     *
     * @return string
     */
    public function getLegalConsentTextColor()
    {
        return $this->container['legal_consent_text_color'];
    }

    /**
     * Sets legal_consent_text_color
     *
     * @param string $legal_consent_text_color 
     *
     * @return self
     */
    public function setLegalConsentTextColor($legal_consent_text_color)
    {
        if (is_null($legal_consent_text_color)) {
            throw new \InvalidArgumentException('non-nullable legal_consent_text_color cannot be null');
        }
        $this->container['legal_consent_text_color'] = $legal_consent_text_color;

        return $this;
    }

    /**
     * Gets font_family
     *
     * @return string
     */
    public function getFontFamily()
    {
        return $this->container['font_family'];
    }

    /**
     * Sets font_family
     *
     * @param string $font_family 
     *
     * @return self
     */
    public function setFontFamily($font_family)
    {
        if (is_null($font_family)) {
            throw new \InvalidArgumentException('non-nullable font_family cannot be null');
        }
        $this->container['font_family'] = $font_family;

        return $this;
    }

    /**
     * Gets legal_consent_text_size
     *
     * @return string
     */
    public function getLegalConsentTextSize()
    {
        return $this->container['legal_consent_text_size'];
    }

    /**
     * Sets legal_consent_text_size
     *
     * @param string $legal_consent_text_size 
     *
     * @return self
     */
    public function setLegalConsentTextSize($legal_consent_text_size)
    {
        if (is_null($legal_consent_text_size)) {
            throw new \InvalidArgumentException('non-nullable legal_consent_text_size cannot be null');
        }
        $this->container['legal_consent_text_size'] = $legal_consent_text_size;

        return $this;
    }

    /**
     * Gets background_width
     *
     * @return string
     */
    public function getBackgroundWidth()
    {
        return $this->container['background_width'];
    }

    /**
     * Sets background_width
     *
     * @param string $background_width 
     *
     * @return self
     */
    public function setBackgroundWidth($background_width)
    {
        if (is_null($background_width)) {
            throw new \InvalidArgumentException('non-nullable background_width cannot be null');
        }
        $this->container['background_width'] = $background_width;

        return $this;
    }

    /**
     * Gets help_text_size
     *
     * @return string
     */
    public function getHelpTextSize()
    {
        return $this->container['help_text_size'];
    }

    /**
     * Sets help_text_size
     *
     * @param string $help_text_size 
     *
     * @return self
     */
    public function setHelpTextSize($help_text_size)
    {
        if (is_null($help_text_size)) {
            throw new \InvalidArgumentException('non-nullable help_text_size cannot be null');
        }
        $this->container['help_text_size'] = $help_text_size;

        return $this;
    }

    /**
     * Gets submit_font_color
     *
     * @return string
     */
    public function getSubmitFontColor()
    {
        return $this->container['submit_font_color'];
    }

    /**
     * Sets submit_font_color
     *
     * @param string $submit_font_color 
     *
     * @return self
     */
    public function setSubmitFontColor($submit_font_color)
    {
        if (is_null($submit_font_color)) {
            throw new \InvalidArgumentException('non-nullable submit_font_color cannot be null');
        }
        $this->container['submit_font_color'] = $submit_font_color;

        return $this;
    }

    /**
     * Gets label_text_color
     *
     * @return string
     */
    public function getLabelTextColor()
    {
        return $this->container['label_text_color'];
    }

    /**
     * Sets label_text_color
     *
     * @param string $label_text_color 
     *
     * @return self
     */
    public function setLabelTextColor($label_text_color)
    {
        if (is_null($label_text_color)) {
            throw new \InvalidArgumentException('non-nullable label_text_color cannot be null');
        }
        $this->container['label_text_color'] = $label_text_color;

        return $this;
    }

    /**
     * Gets submit_alignment
     *
     * @return string
     */
    public function getSubmitAlignment()
    {
        return $this->container['submit_alignment'];
    }

    /**
     * Sets submit_alignment
     *
     * @param string $submit_alignment 
     *
     * @return self
     */
    public function setSubmitAlignment($submit_alignment)
    {
        if (is_null($submit_alignment)) {
            throw new \InvalidArgumentException('non-nullable submit_alignment cannot be null');
        }
        $allowedValues = $this->getSubmitAlignmentAllowableValues();
        if (!in_array($submit_alignment, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'submit_alignment', must be one of '%s'",
                    $submit_alignment,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['submit_alignment'] = $submit_alignment;

        return $this;
    }

    /**
     * Gets submit_size
     *
     * @return string
     */
    public function getSubmitSize()
    {
        return $this->container['submit_size'];
    }

    /**
     * Sets submit_size
     *
     * @param string $submit_size 
     *
     * @return self
     */
    public function setSubmitSize($submit_size)
    {
        if (is_null($submit_size)) {
            throw new \InvalidArgumentException('non-nullable submit_size cannot be null');
        }
        $this->container['submit_size'] = $submit_size;

        return $this;
    }

    /**
     * Gets help_text_color
     *
     * @return string
     */
    public function getHelpTextColor()
    {
        return $this->container['help_text_color'];
    }

    /**
     * Sets help_text_color
     *
     * @param string $help_text_color 
     *
     * @return self
     */
    public function setHelpTextColor($help_text_color)
    {
        if (is_null($help_text_color)) {
            throw new \InvalidArgumentException('non-nullable help_text_color cannot be null');
        }
        $this->container['help_text_color'] = $help_text_color;

        return $this;
    }

    /**
     * Gets submit_color
     *
     * @return string
     */
    public function getSubmitColor()
    {
        return $this->container['submit_color'];
    }

    /**
     * Sets submit_color
     *
     * @param string $submit_color 
     *
     * @return self
     */
    public function setSubmitColor($submit_color)
    {
        if (is_null($submit_color)) {
            throw new \InvalidArgumentException('non-nullable submit_color cannot be null');
        }
        $this->container['submit_color'] = $submit_color;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


