<?php
/**
 * FunctionsApi
 * PHP version 7.4
 *
 * @category Class
 * @package  HubSpot\Client\Automation\Actions
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Automation Actions V4
 *
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v4
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 7.3.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace HubSpot\Client\Automation\Actions\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use HubSpot\Client\Automation\Actions\ApiException;
use HubSpot\Client\Automation\Actions\Configuration;
use HubSpot\Client\Automation\Actions\HeaderSelector;
use HubSpot\Client\Automation\Actions\ObjectSerializer;

/**
 * FunctionsApi Class Doc Comment
 *
 * @category Class
 * @package  HubSpot\Client\Automation\Actions
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class FunctionsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'archive' => [
            'application/json',
        ],
        'archiveByFunctionType' => [
            'application/json',
        ],
        'createOrReplace' => [
            'text/plain',
        ],
        'createOrReplaceByFunctionType' => [
            'text/plain',
        ],
        'getByFunctionType' => [
            'application/json',
        ],
        'getById' => [
            'application/json',
        ],
        'getPage' => [
            'application/json',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation archive
     *
     * Archive a function for a definition
     *
     * @param  string $definition_id definition_id (required)
     * @param  string $function_type function_type (required)
     * @param  string $function_id function_id (required)
     * @param  int $app_id app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archive'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Automation\Actions\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function archive($definition_id, $function_type, $function_id, $app_id, string $contentType = self::contentTypes['archive'][0])
    {
        $this->archiveWithHttpInfo($definition_id, $function_type, $function_id, $app_id, $contentType);
    }

    /**
     * Operation archiveWithHttpInfo
     *
     * Archive a function for a definition
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  string $function_id (required)
     * @param  int $app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archive'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Automation\Actions\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function archiveWithHttpInfo($definition_id, $function_type, $function_id, $app_id, string $contentType = self::contentTypes['archive'][0])
    {
        $request = $this->archiveRequest($definition_id, $function_type, $function_id, $app_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Automation\Actions\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation archiveAsync
     *
     * Archive a function for a definition
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  string $function_id (required)
     * @param  int $app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archive'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveAsync($definition_id, $function_type, $function_id, $app_id, string $contentType = self::contentTypes['archive'][0])
    {
        return $this->archiveAsyncWithHttpInfo($definition_id, $function_type, $function_id, $app_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation archiveAsyncWithHttpInfo
     *
     * Archive a function for a definition
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  string $function_id (required)
     * @param  int $app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archive'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveAsyncWithHttpInfo($definition_id, $function_type, $function_id, $app_id, string $contentType = self::contentTypes['archive'][0])
    {
        $returnType = '';
        $request = $this->archiveRequest($definition_id, $function_type, $function_id, $app_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'archive'
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  string $function_id (required)
     * @param  int $app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archive'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function archiveRequest($definition_id, $function_type, $function_id, $app_id, string $contentType = self::contentTypes['archive'][0])
    {

        // verify the required parameter 'definition_id' is set
        if ($definition_id === null || (is_array($definition_id) && count($definition_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $definition_id when calling archive'
            );
        }

        // verify the required parameter 'function_type' is set
        if ($function_type === null || (is_array($function_type) && count($function_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $function_type when calling archive'
            );
        }

        // verify the required parameter 'function_id' is set
        if ($function_id === null || (is_array($function_id) && count($function_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $function_id when calling archive'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling archive'
            );
        }


        $resourcePath = '/automation/v4/actions/{appId}/{definitionId}/functions/{functionType}/{functionId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($definition_id !== null) {
            $resourcePath = str_replace(
                '{' . 'definitionId' . '}',
                ObjectSerializer::toPathValue($definition_id),
                $resourcePath
            );
        }
        // path params
        if ($function_type !== null) {
            $resourcePath = str_replace(
                '{' . 'functionType' . '}',
                ObjectSerializer::toPathValue($function_type),
                $resourcePath
            );
        }
        // path params
        if ($function_id !== null) {
            $resourcePath = str_replace(
                '{' . 'functionId' . '}',
                ObjectSerializer::toPathValue($function_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'appId' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation archiveByFunctionType
     *
     * Delete a function for a definition
     *
     * @param  string $definition_id definition_id (required)
     * @param  string $function_type function_type (required)
     * @param  int $app_id app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archiveByFunctionType'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Automation\Actions\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return void
     */
    public function archiveByFunctionType($definition_id, $function_type, $app_id, string $contentType = self::contentTypes['archiveByFunctionType'][0])
    {
        $this->archiveByFunctionTypeWithHttpInfo($definition_id, $function_type, $app_id, $contentType);
    }

    /**
     * Operation archiveByFunctionTypeWithHttpInfo
     *
     * Delete a function for a definition
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  int $app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archiveByFunctionType'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Automation\Actions\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function archiveByFunctionTypeWithHttpInfo($definition_id, $function_type, $app_id, string $contentType = self::contentTypes['archiveByFunctionType'][0])
    {
        $request = $this->archiveByFunctionTypeRequest($definition_id, $function_type, $app_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Automation\Actions\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation archiveByFunctionTypeAsync
     *
     * Delete a function for a definition
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  int $app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archiveByFunctionType'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveByFunctionTypeAsync($definition_id, $function_type, $app_id, string $contentType = self::contentTypes['archiveByFunctionType'][0])
    {
        return $this->archiveByFunctionTypeAsyncWithHttpInfo($definition_id, $function_type, $app_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation archiveByFunctionTypeAsyncWithHttpInfo
     *
     * Delete a function for a definition
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  int $app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archiveByFunctionType'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function archiveByFunctionTypeAsyncWithHttpInfo($definition_id, $function_type, $app_id, string $contentType = self::contentTypes['archiveByFunctionType'][0])
    {
        $returnType = '';
        $request = $this->archiveByFunctionTypeRequest($definition_id, $function_type, $app_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'archiveByFunctionType'
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  int $app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['archiveByFunctionType'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function archiveByFunctionTypeRequest($definition_id, $function_type, $app_id, string $contentType = self::contentTypes['archiveByFunctionType'][0])
    {

        // verify the required parameter 'definition_id' is set
        if ($definition_id === null || (is_array($definition_id) && count($definition_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $definition_id when calling archiveByFunctionType'
            );
        }

        // verify the required parameter 'function_type' is set
        if ($function_type === null || (is_array($function_type) && count($function_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $function_type when calling archiveByFunctionType'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling archiveByFunctionType'
            );
        }


        $resourcePath = '/automation/v4/actions/{appId}/{definitionId}/functions/{functionType}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($definition_id !== null) {
            $resourcePath = str_replace(
                '{' . 'definitionId' . '}',
                ObjectSerializer::toPathValue($definition_id),
                $resourcePath
            );
        }
        // path params
        if ($function_type !== null) {
            $resourcePath = str_replace(
                '{' . 'functionType' . '}',
                ObjectSerializer::toPathValue($function_type),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'appId' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createOrReplace
     *
     * Insert a function for a definition
     *
     * @param  string $definition_id definition_id (required)
     * @param  string $function_type function_type (required)
     * @param  string $function_id function_id (required)
     * @param  int $app_id app_id (required)
     * @param  string $body body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrReplace'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Automation\Actions\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Automation\Actions\Model\PublicActionFunctionIdentifier|\HubSpot\Client\Automation\Actions\Model\Error
     */
    public function createOrReplace($definition_id, $function_type, $function_id, $app_id, $body, string $contentType = self::contentTypes['createOrReplace'][0])
    {
        list($response) = $this->createOrReplaceWithHttpInfo($definition_id, $function_type, $function_id, $app_id, $body, $contentType);
        return $response;
    }

    /**
     * Operation createOrReplaceWithHttpInfo
     *
     * Insert a function for a definition
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  string $function_id (required)
     * @param  int $app_id (required)
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrReplace'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Automation\Actions\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Automation\Actions\Model\PublicActionFunctionIdentifier|\HubSpot\Client\Automation\Actions\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createOrReplaceWithHttpInfo($definition_id, $function_type, $function_id, $app_id, $body, string $contentType = self::contentTypes['createOrReplace'][0])
    {
        $request = $this->createOrReplaceRequest($definition_id, $function_type, $function_id, $app_id, $body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Automation\Actions\Model\PublicActionFunctionIdentifier' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Automation\Actions\Model\PublicActionFunctionIdentifier' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Automation\Actions\Model\PublicActionFunctionIdentifier', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Automation\Actions\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Automation\Actions\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Automation\Actions\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Automation\Actions\Model\PublicActionFunctionIdentifier';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Automation\Actions\Model\PublicActionFunctionIdentifier',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Automation\Actions\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createOrReplaceAsync
     *
     * Insert a function for a definition
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  string $function_id (required)
     * @param  int $app_id (required)
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrReplace'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOrReplaceAsync($definition_id, $function_type, $function_id, $app_id, $body, string $contentType = self::contentTypes['createOrReplace'][0])
    {
        return $this->createOrReplaceAsyncWithHttpInfo($definition_id, $function_type, $function_id, $app_id, $body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createOrReplaceAsyncWithHttpInfo
     *
     * Insert a function for a definition
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  string $function_id (required)
     * @param  int $app_id (required)
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrReplace'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOrReplaceAsyncWithHttpInfo($definition_id, $function_type, $function_id, $app_id, $body, string $contentType = self::contentTypes['createOrReplace'][0])
    {
        $returnType = '\HubSpot\Client\Automation\Actions\Model\PublicActionFunctionIdentifier';
        $request = $this->createOrReplaceRequest($definition_id, $function_type, $function_id, $app_id, $body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createOrReplace'
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  string $function_id (required)
     * @param  int $app_id (required)
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrReplace'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createOrReplaceRequest($definition_id, $function_type, $function_id, $app_id, $body, string $contentType = self::contentTypes['createOrReplace'][0])
    {

        // verify the required parameter 'definition_id' is set
        if ($definition_id === null || (is_array($definition_id) && count($definition_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $definition_id when calling createOrReplace'
            );
        }

        // verify the required parameter 'function_type' is set
        if ($function_type === null || (is_array($function_type) && count($function_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $function_type when calling createOrReplace'
            );
        }

        // verify the required parameter 'function_id' is set
        if ($function_id === null || (is_array($function_id) && count($function_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $function_id when calling createOrReplace'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling createOrReplace'
            );
        }

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createOrReplace'
            );
        }


        $resourcePath = '/automation/v4/actions/{appId}/{definitionId}/functions/{functionType}/{functionId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($definition_id !== null) {
            $resourcePath = str_replace(
                '{' . 'definitionId' . '}',
                ObjectSerializer::toPathValue($definition_id),
                $resourcePath
            );
        }
        // path params
        if ($function_type !== null) {
            $resourcePath = str_replace(
                '{' . 'functionType' . '}',
                ObjectSerializer::toPathValue($function_type),
                $resourcePath
            );
        }
        // path params
        if ($function_id !== null) {
            $resourcePath = str_replace(
                '{' . 'functionId' . '}',
                ObjectSerializer::toPathValue($function_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'appId' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation createOrReplaceByFunctionType
     *
     * Insert a function for a definition
     *
     * @param  string $definition_id definition_id (required)
     * @param  string $function_type function_type (required)
     * @param  int $app_id app_id (required)
     * @param  string $body body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrReplaceByFunctionType'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Automation\Actions\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Automation\Actions\Model\PublicActionFunctionIdentifier|\HubSpot\Client\Automation\Actions\Model\Error
     */
    public function createOrReplaceByFunctionType($definition_id, $function_type, $app_id, $body, string $contentType = self::contentTypes['createOrReplaceByFunctionType'][0])
    {
        list($response) = $this->createOrReplaceByFunctionTypeWithHttpInfo($definition_id, $function_type, $app_id, $body, $contentType);
        return $response;
    }

    /**
     * Operation createOrReplaceByFunctionTypeWithHttpInfo
     *
     * Insert a function for a definition
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  int $app_id (required)
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrReplaceByFunctionType'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Automation\Actions\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Automation\Actions\Model\PublicActionFunctionIdentifier|\HubSpot\Client\Automation\Actions\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function createOrReplaceByFunctionTypeWithHttpInfo($definition_id, $function_type, $app_id, $body, string $contentType = self::contentTypes['createOrReplaceByFunctionType'][0])
    {
        $request = $this->createOrReplaceByFunctionTypeRequest($definition_id, $function_type, $app_id, $body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Automation\Actions\Model\PublicActionFunctionIdentifier' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Automation\Actions\Model\PublicActionFunctionIdentifier' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Automation\Actions\Model\PublicActionFunctionIdentifier', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Automation\Actions\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Automation\Actions\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Automation\Actions\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Automation\Actions\Model\PublicActionFunctionIdentifier';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Automation\Actions\Model\PublicActionFunctionIdentifier',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Automation\Actions\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createOrReplaceByFunctionTypeAsync
     *
     * Insert a function for a definition
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  int $app_id (required)
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrReplaceByFunctionType'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOrReplaceByFunctionTypeAsync($definition_id, $function_type, $app_id, $body, string $contentType = self::contentTypes['createOrReplaceByFunctionType'][0])
    {
        return $this->createOrReplaceByFunctionTypeAsyncWithHttpInfo($definition_id, $function_type, $app_id, $body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createOrReplaceByFunctionTypeAsyncWithHttpInfo
     *
     * Insert a function for a definition
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  int $app_id (required)
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrReplaceByFunctionType'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createOrReplaceByFunctionTypeAsyncWithHttpInfo($definition_id, $function_type, $app_id, $body, string $contentType = self::contentTypes['createOrReplaceByFunctionType'][0])
    {
        $returnType = '\HubSpot\Client\Automation\Actions\Model\PublicActionFunctionIdentifier';
        $request = $this->createOrReplaceByFunctionTypeRequest($definition_id, $function_type, $app_id, $body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createOrReplaceByFunctionType'
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  int $app_id (required)
     * @param  string $body (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createOrReplaceByFunctionType'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createOrReplaceByFunctionTypeRequest($definition_id, $function_type, $app_id, $body, string $contentType = self::contentTypes['createOrReplaceByFunctionType'][0])
    {

        // verify the required parameter 'definition_id' is set
        if ($definition_id === null || (is_array($definition_id) && count($definition_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $definition_id when calling createOrReplaceByFunctionType'
            );
        }

        // verify the required parameter 'function_type' is set
        if ($function_type === null || (is_array($function_type) && count($function_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $function_type when calling createOrReplaceByFunctionType'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling createOrReplaceByFunctionType'
            );
        }

        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling createOrReplaceByFunctionType'
            );
        }


        $resourcePath = '/automation/v4/actions/{appId}/{definitionId}/functions/{functionType}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($definition_id !== null) {
            $resourcePath = str_replace(
                '{' . 'definitionId' . '}',
                ObjectSerializer::toPathValue($definition_id),
                $resourcePath
            );
        }
        // path params
        if ($function_type !== null) {
            $resourcePath = str_replace(
                '{' . 'functionType' . '}',
                ObjectSerializer::toPathValue($function_type),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'appId' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getByFunctionType
     *
     * Get all functions by a type for a given definition
     *
     * @param  string $definition_id definition_id (required)
     * @param  string $function_type function_type (required)
     * @param  int $app_id app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getByFunctionType'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Automation\Actions\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Automation\Actions\Model\PublicActionFunction|\HubSpot\Client\Automation\Actions\Model\Error
     */
    public function getByFunctionType($definition_id, $function_type, $app_id, string $contentType = self::contentTypes['getByFunctionType'][0])
    {
        list($response) = $this->getByFunctionTypeWithHttpInfo($definition_id, $function_type, $app_id, $contentType);
        return $response;
    }

    /**
     * Operation getByFunctionTypeWithHttpInfo
     *
     * Get all functions by a type for a given definition
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  int $app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getByFunctionType'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Automation\Actions\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Automation\Actions\Model\PublicActionFunction|\HubSpot\Client\Automation\Actions\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getByFunctionTypeWithHttpInfo($definition_id, $function_type, $app_id, string $contentType = self::contentTypes['getByFunctionType'][0])
    {
        $request = $this->getByFunctionTypeRequest($definition_id, $function_type, $app_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Automation\Actions\Model\PublicActionFunction' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Automation\Actions\Model\PublicActionFunction' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Automation\Actions\Model\PublicActionFunction', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Automation\Actions\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Automation\Actions\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Automation\Actions\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Automation\Actions\Model\PublicActionFunction';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Automation\Actions\Model\PublicActionFunction',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Automation\Actions\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getByFunctionTypeAsync
     *
     * Get all functions by a type for a given definition
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  int $app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getByFunctionType'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getByFunctionTypeAsync($definition_id, $function_type, $app_id, string $contentType = self::contentTypes['getByFunctionType'][0])
    {
        return $this->getByFunctionTypeAsyncWithHttpInfo($definition_id, $function_type, $app_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getByFunctionTypeAsyncWithHttpInfo
     *
     * Get all functions by a type for a given definition
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  int $app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getByFunctionType'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getByFunctionTypeAsyncWithHttpInfo($definition_id, $function_type, $app_id, string $contentType = self::contentTypes['getByFunctionType'][0])
    {
        $returnType = '\HubSpot\Client\Automation\Actions\Model\PublicActionFunction';
        $request = $this->getByFunctionTypeRequest($definition_id, $function_type, $app_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getByFunctionType'
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  int $app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getByFunctionType'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getByFunctionTypeRequest($definition_id, $function_type, $app_id, string $contentType = self::contentTypes['getByFunctionType'][0])
    {

        // verify the required parameter 'definition_id' is set
        if ($definition_id === null || (is_array($definition_id) && count($definition_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $definition_id when calling getByFunctionType'
            );
        }

        // verify the required parameter 'function_type' is set
        if ($function_type === null || (is_array($function_type) && count($function_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $function_type when calling getByFunctionType'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling getByFunctionType'
            );
        }


        $resourcePath = '/automation/v4/actions/{appId}/{definitionId}/functions/{functionType}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($definition_id !== null) {
            $resourcePath = str_replace(
                '{' . 'definitionId' . '}',
                ObjectSerializer::toPathValue($definition_id),
                $resourcePath
            );
        }
        // path params
        if ($function_type !== null) {
            $resourcePath = str_replace(
                '{' . 'functionType' . '}',
                ObjectSerializer::toPathValue($function_type),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'appId' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getById
     *
     * Get a function for a given definition
     *
     * @param  string $definition_id definition_id (required)
     * @param  string $function_type function_type (required)
     * @param  string $function_id function_id (required)
     * @param  int $app_id app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getById'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Automation\Actions\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Automation\Actions\Model\PublicActionFunction|\HubSpot\Client\Automation\Actions\Model\Error
     */
    public function getById($definition_id, $function_type, $function_id, $app_id, string $contentType = self::contentTypes['getById'][0])
    {
        list($response) = $this->getByIdWithHttpInfo($definition_id, $function_type, $function_id, $app_id, $contentType);
        return $response;
    }

    /**
     * Operation getByIdWithHttpInfo
     *
     * Get a function for a given definition
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  string $function_id (required)
     * @param  int $app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getById'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Automation\Actions\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Automation\Actions\Model\PublicActionFunction|\HubSpot\Client\Automation\Actions\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getByIdWithHttpInfo($definition_id, $function_type, $function_id, $app_id, string $contentType = self::contentTypes['getById'][0])
    {
        $request = $this->getByIdRequest($definition_id, $function_type, $function_id, $app_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Automation\Actions\Model\PublicActionFunction' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Automation\Actions\Model\PublicActionFunction' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Automation\Actions\Model\PublicActionFunction', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Automation\Actions\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Automation\Actions\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Automation\Actions\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Automation\Actions\Model\PublicActionFunction';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Automation\Actions\Model\PublicActionFunction',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Automation\Actions\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getByIdAsync
     *
     * Get a function for a given definition
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  string $function_id (required)
     * @param  int $app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getByIdAsync($definition_id, $function_type, $function_id, $app_id, string $contentType = self::contentTypes['getById'][0])
    {
        return $this->getByIdAsyncWithHttpInfo($definition_id, $function_type, $function_id, $app_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getByIdAsyncWithHttpInfo
     *
     * Get a function for a given definition
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  string $function_id (required)
     * @param  int $app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getByIdAsyncWithHttpInfo($definition_id, $function_type, $function_id, $app_id, string $contentType = self::contentTypes['getById'][0])
    {
        $returnType = '\HubSpot\Client\Automation\Actions\Model\PublicActionFunction';
        $request = $this->getByIdRequest($definition_id, $function_type, $function_id, $app_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getById'
     *
     * @param  string $definition_id (required)
     * @param  string $function_type (required)
     * @param  string $function_id (required)
     * @param  int $app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getById'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getByIdRequest($definition_id, $function_type, $function_id, $app_id, string $contentType = self::contentTypes['getById'][0])
    {

        // verify the required parameter 'definition_id' is set
        if ($definition_id === null || (is_array($definition_id) && count($definition_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $definition_id when calling getById'
            );
        }

        // verify the required parameter 'function_type' is set
        if ($function_type === null || (is_array($function_type) && count($function_type) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $function_type when calling getById'
            );
        }

        // verify the required parameter 'function_id' is set
        if ($function_id === null || (is_array($function_id) && count($function_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $function_id when calling getById'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling getById'
            );
        }


        $resourcePath = '/automation/v4/actions/{appId}/{definitionId}/functions/{functionType}/{functionId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($definition_id !== null) {
            $resourcePath = str_replace(
                '{' . 'definitionId' . '}',
                ObjectSerializer::toPathValue($definition_id),
                $resourcePath
            );
        }
        // path params
        if ($function_type !== null) {
            $resourcePath = str_replace(
                '{' . 'functionType' . '}',
                ObjectSerializer::toPathValue($function_type),
                $resourcePath
            );
        }
        // path params
        if ($function_id !== null) {
            $resourcePath = str_replace(
                '{' . 'functionId' . '}',
                ObjectSerializer::toPathValue($function_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'appId' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getPage
     *
     * Get all functions for a given definition
     *
     * @param  string $definition_id definition_id (required)
     * @param  int $app_id app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPage'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Automation\Actions\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \HubSpot\Client\Automation\Actions\Model\CollectionResponsePublicActionFunctionIdentifierNoPaging|\HubSpot\Client\Automation\Actions\Model\Error
     */
    public function getPage($definition_id, $app_id, string $contentType = self::contentTypes['getPage'][0])
    {
        list($response) = $this->getPageWithHttpInfo($definition_id, $app_id, $contentType);
        return $response;
    }

    /**
     * Operation getPageWithHttpInfo
     *
     * Get all functions for a given definition
     *
     * @param  string $definition_id (required)
     * @param  int $app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPage'] to see the possible values for this operation
     *
     * @throws \HubSpot\Client\Automation\Actions\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \HubSpot\Client\Automation\Actions\Model\CollectionResponsePublicActionFunctionIdentifierNoPaging|\HubSpot\Client\Automation\Actions\Model\Error, HTTP status code, HTTP response headers (array of strings)
     */
    public function getPageWithHttpInfo($definition_id, $app_id, string $contentType = self::contentTypes['getPage'][0])
    {
        $request = $this->getPageRequest($definition_id, $app_id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\HubSpot\Client\Automation\Actions\Model\CollectionResponsePublicActionFunctionIdentifierNoPaging' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Automation\Actions\Model\CollectionResponsePublicActionFunctionIdentifierNoPaging' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Automation\Actions\Model\CollectionResponsePublicActionFunctionIdentifierNoPaging', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                default:
                    if ('\HubSpot\Client\Automation\Actions\Model\Error' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\HubSpot\Client\Automation\Actions\Model\Error' !== 'string') {
                            try {
                                $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                            } catch (\JsonException $exception) {
                                throw new ApiException(
                                    sprintf(
                                        'Error JSON decoding server response (%s)',
                                        $request->getUri()
                                    ),
                                    $statusCode,
                                    $response->getHeaders(),
                                    $content
                                );
                            }
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\HubSpot\Client\Automation\Actions\Model\Error', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\HubSpot\Client\Automation\Actions\Model\CollectionResponsePublicActionFunctionIdentifierNoPaging';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    try {
                        $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                    } catch (\JsonException $exception) {
                        throw new ApiException(
                            sprintf(
                                'Error JSON decoding server response (%s)',
                                $request->getUri()
                            ),
                            $statusCode,
                            $response->getHeaders(),
                            $content
                        );
                    }
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Automation\Actions\Model\CollectionResponsePublicActionFunctionIdentifierNoPaging',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                default:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\HubSpot\Client\Automation\Actions\Model\Error',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getPageAsync
     *
     * Get all functions for a given definition
     *
     * @param  string $definition_id (required)
     * @param  int $app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPageAsync($definition_id, $app_id, string $contentType = self::contentTypes['getPage'][0])
    {
        return $this->getPageAsyncWithHttpInfo($definition_id, $app_id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getPageAsyncWithHttpInfo
     *
     * Get all functions for a given definition
     *
     * @param  string $definition_id (required)
     * @param  int $app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getPageAsyncWithHttpInfo($definition_id, $app_id, string $contentType = self::contentTypes['getPage'][0])
    {
        $returnType = '\HubSpot\Client\Automation\Actions\Model\CollectionResponsePublicActionFunctionIdentifierNoPaging';
        $request = $this->getPageRequest($definition_id, $app_id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getPage'
     *
     * @param  string $definition_id (required)
     * @param  int $app_id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getPage'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getPageRequest($definition_id, $app_id, string $contentType = self::contentTypes['getPage'][0])
    {

        // verify the required parameter 'definition_id' is set
        if ($definition_id === null || (is_array($definition_id) && count($definition_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $definition_id when calling getPage'
            );
        }

        // verify the required parameter 'app_id' is set
        if ($app_id === null || (is_array($app_id) && count($app_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $app_id when calling getPage'
            );
        }


        $resourcePath = '/automation/v4/actions/{appId}/{definitionId}/functions';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($definition_id !== null) {
            $resourcePath = str_replace(
                '{' . 'definitionId' . '}',
                ObjectSerializer::toPathValue($definition_id),
                $resourcePath
            );
        }
        // path params
        if ($app_id !== null) {
            $resourcePath = str_replace(
                '{' . 'appId' . '}',
                ObjectSerializer::toPathValue($app_id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', '*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('hapikey');
        if ($apiKey !== null) {
            $queryParams['hapikey'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
