/*
 * Supercode TinyMCE Plugin - MODIFIED BY LIQUID THEMES
 * Supercode is an enhanced source code editor plugin for TinyMCE, the popular web-based WYSIWYG editor. This plugin provides users with a seamless experience for editing and displaying source code within the TinyMCE editor environment.
 *
 * Repository: https://github.com/prathamVaidya/supercode-tinymce-plugin
 * Author: Pratham Vaidya
 * License: GPL-3.0
 * Version: 1.2.0
 *
 * Released under the GPL-3.0 License.
 */

!function(){"use strict";let e=`
    <div id="supercode-backdrop"></div>
    <div id="supercode-modal">
        <div id="supercode-header">
            <h1>Source Code Editor</h1>
            <button id="supercode-close-btn">
                Close
            </button>
        </div>
        <div id="supercode-editor"></div>
        <div id="supercode-footer">
            <button id="supercode-cancel-btn">
                Cancel
            </button>
            <button id="supercode-save-btn">
                Save
            </button>
        </div>
    </div>
`,o=`

    :root{
        --supercode-modal-primary: #ffffff;
        --supercode-modal-secondary: #222f3e;
        --supercode-modal-border: rgba(0, 0, 0, 0.1);
    }

    /* Media query for mobile devices */
    @media only screen and (max-width: 767px) {
        #supercode-modal {
            width: 100% !important;
            height: 100% !important;
            border-radius: 0 !important;
        }
    }
    .disable-scroll {
        overflow: hidden;
    }
    #supercode-modal-container {
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        display: flex;
        align-items: center;
        justify-content: center;
        z-index: 990;
        display: none;
        opacity: 0;
        transition: opacity 0.1s linear;
    }
    #supercode-backdrop {
        position: absolute;
        top: 0;
        left: 0;
        background: black;
        opacity: 0.7;
        width: 100%;
        height: 100%;
        z-index: 1;
    }
    #supercode-modal {
        width: 90%;
        height: 80%;
        max-width: 1200px;
        z-index: 2;
        overflow: hidden;
        border-radius: 10px;
        display: flex;
        flex-direction: column;
        background: var(--supercode-modal-primary);
    }
    #supercode-header {
        display: flex;
        padding: 0.5rem 1rem;
        border-bottom: 1px solid var(--supercode-modal-border);
        color: var(--supercode-modal-secondary);
    }
    #supercode-modal h1 {
        flex-grow: 1;
        margin: auto;
        font-size: 14px;
    }
    #supercode-close-btn {
        background: none;
        border: none;
        padding: 0;
        height: 100%;
        cursor: pointer;
        fill: var(--supercode-modal-secondary);
    }
    #supercode-editor {
        width: 100%;
        height: 100%;
        position: relative;
    }
    #supercode-footer {
        padding: 0.5rem 1rem;
        display: flex;
        justify-content: end;
        gap: 1rem;
        border-top: 1px solid var(--supercode-modal-border);
    }
    #supercode-footer button {
        padding: 0.5rem 1rem;
        border-radius: 5px;
        font-weight: bold;
        border: none;
        cursor: pointer;
        min-width: 5rem;
        transition: opacity 0.1s linear;
    }
    #supercode-footer button:hover {
        opacity: 0.8;
    }
    #supercode-cancel-btn {
        background: transparent;
        color: var(--supercode-modal-secondary);
    }
    #supercode-save-btn {
        background: var(--supercode-modal-secondary);
        color: var(--supercode-modal-primary);
    }
    `,t=null,r=e=>{let o=document.createElement("style");o.innerHTML=e,document.head.append(o)},d=function(d){let a=0,l,n=!1,i,c,s={theme:"chrome",fontSize:14,wrap:!0,icon:void 0,iconName:"sourcecode",autocomplete:!1,language:"html",renderer:null,parser:null,shortcut:!0,aceCss:null,fontFamily:null,fallbackModal:!1,modalPrimaryColor:"#ffffff",modalSecondaryColor:"#222f3e",dark:!1,debug:!0},u=()=>{let e={};s.autocomplete&&(e.enableLiveAutocompletion=!0),s.fontFamily&&(e.fontFamily=s.fontFamily),c.setOptions(e),c.setTheme(`ace/theme/${s.theme}`),c.setFontSize(s.fontSize),c.setShowPrintMargin(!1)},p=e=>{if(e.attachShadow({mode:"open"}),s.aceCss){let o=new CSSStyleSheet;o.replaceSync(s.aceCss),e.shadowRoot.adoptedStyleSheets.push(o)}e.shadowRoot.innerHTML='<div class="supercode-editor" style="width: 100%; height: 100%; position: absolute; left:0; top:0"></div>';let t=e.shadowRoot.querySelector(".supercode-editor");t.style.width="100%",t.style.height="100%",(c=ace.edit(t)).renderer.attachToShadowRoot(),u()},m=(e,o)=>{let t=o.cloneNode(!0);t.style.position="relative";let r=t.querySelector(".tox-menubar");r&&(r.innerHTML="<b style='font-size: 14px; font-weight: bold; padding: 11px 9px;'>Source Code Editor</b>");let d=null,a=!1;t.querySelectorAll(".tox-tbtn, .tox-split-button").forEach(e=>{let o="supercode"===e.getAttribute("data-mce-name")||"Source Code Editor (Ctrl + space)"===e.getAttribute("aria-label");o?(a=!0,e.setAttribute("data-mce-name","supercode-toggle"),e.classList.add("tox-tbtn--enabled"),e.onclick=h):(("overflow-button"===e.getAttribute("data-mce-name")||"true"==e.getAttribute("aria-haspopup"))&&(d=e),e.classList.remove("tox-tbtn--enabled"),e.classList.add("tox-tbtn--disabled"),e.removeAttribute("data-mce-name"))}),!a&&d&&(d.classList="tox-tbtn tox-tbtn--enabled",d.innerHTML=`<span class="tox-icon tox-tbtn__icon-wrap">${s.icon}</span>`,d.onclick=h),e.innerHTML="",e.append(t)},y=(e,o)=>{e.style.width=o+"px",e.style.height="100%",e.style.position="relative",p(e)};(e=>{let o=e.getParam("supercode");if(o&&"object"==typeof o){for(let t in o)if(o.hasOwnProperty(t)){let r=o[t];switch(t){case"theme":case"language":case"iconName":case"aceCss":case"fontFamily":case"modalPrimaryColor":case"modalSecondaryColor":"string"==typeof r&&(s[t]=r);break;case"fontSize":"number"==typeof r&&r>0&&(s.fontSize=parseInt(r));break;case"wrap":case"autocomplete":case"shortcut":case"fallbackModal":case"dark":case"debug":"boolean"==typeof r&&(s[t]=r);break;case"parser":case"renderer":"function"==typeof r&&(s[t]=r)}}}s.icon=e.ui.registry.getAll?.().icons?.[s.iconName],s.icon||(s.icon='<svg width="24" height="24" focusable="false"><g fill-rule="nonzero"><path d="M9.8 15.7c.3.3.3.8 0 1-.3.4-.9.4-1.2 0l-4.4-4.1a.8.8 0 0 1 0-1.2l4.4-4.2c.3-.3.9-.3 1.2 0 .3.3.3.8 0 1.1L6 12l3.8 3.7ZM14.2 15.7c-.3.3-.3.8 0 1 .4.4.9.4 1.2 0l4.4-4.1c.3-.3.3-.9 0-1.2l-4.4-4.2a.8.8 0 0 0-1.2 0c-.3.3-.3.8 0 1.1L18 12l-3.8 3.7Z"></path></g></svg>'),!s.fallbackModal&&(!0===e.getParam("inline")||tinymce.majorVersion<=5)&&(s.fallbackModal=!0)})(d);let b=e=>{"Escape"===e.key&&_()},$=()=>{if(!t){let a=document.createElement("div");a.id="supercode-modal-container",a.innerHTML=e,r(o),document.body.append(a),t={element:a,editor:ace.edit(a.querySelector("#supercode-editor"))}}c=t.editor,u(),t.element.querySelector("#supercode-backdrop").onclick=_,t.element.querySelector("#supercode-close-btn").onclick=_,t.element.querySelector("#supercode-cancel-btn").onclick=_,t.element.querySelector("#supercode-save-btn").onclick=()=>{h(),_()},s.shortcut&&t.element.querySelector("#supercode-editor").addEventListener("keydown",b),document.querySelector("body").classList.add("disable-scroll"),document.body.style.setProperty("--supercode-modal-primary",s.modalPrimaryColor),document.body.style.setProperty("--supercode-modal-secondary",s.modalSecondaryColor),s.dark&&document.body.style.setProperty("--supercode-modal-border","rgba(255, 255, 255, 0.1)"),t.element.querySelector("#supercode-close-btn").innerHTML=d.ui.registry.getAll?.().icons?.close??'<svg width="24" height="24"><path d="M17.3 8.2 13.4 12l3.9 3.8a1 1 0 0 1-1.5 1.5L12 13.4l-3.8 3.9a1 1 0 0 1-1.5-1.5l3.9-3.8-3.9-3.8a1 1 0 0 1 1.5-1.5l3.8 3.9 3.8-3.9a1 1 0 0 1 1.5 1.5Z" fill-rule="evenodd"></path></svg>',t.element.style.display="flex",setTimeout(()=>{t.element.style.opacity=1},10),v()},_=()=>{s.shortcut&&removeEventListener("keydown",b),document.querySelector("body").classList.remove("disable-scroll"),t.element.style.opacity=0,d.focus(),setTimeout(()=>{t.element.style.display="none"},10)},h=()=>{d.focus(),d.undoManager.transact(function(){let e=c.getValue();s.renderer&&(e=s.renderer(e)),d.setContent(e)}),d.selection.setCursorLocation(),d.nodeChanged(),d.execCommand("ToggleView",!1,"supercode")},f=e=>{(" "===e.key&&e.ctrlKey||"Escape"===e.key)&&h()},g=e=>s.parser?s.parser(e):html_beautify(e),v=()=>{let e=g(d.getContent());i||(i=ace.createEditSession(e,`ace/mode/${s.language}`)).setUseWrapMode(s.wrap),c.setSession(i),i.setValue(e),c.gotoLine(1/0),c.focus()},x=function(){if(s.fallbackModal)$();else{let e=d.getContainer();a&&(n=a!=e.clientWidth),a=e.clientWidth,(n||!l)&&(l=e.querySelector(".tox-editor-header")),d.execCommand("ToggleView",!1,"supercode")}};return s.fallbackModal||d.ui.registry.addView("supercode",{onShow(e){let o=e.getContainer();n&&(m(o.querySelector(".supercode-header"),l),o.querySelector(".supercode-body ").style.width=a+"px",c.resize()),0===o.childElementCount&&(o.style.padding=0,o.style.display="flex",o.style.flexDirection="column",o.innerHTML='<div class="supercode-header"></div><div class="supercode-body"></div>',s.shortcut&&o.addEventListener("keydown",f),m(o.querySelector(".supercode-header"),l),y(o.querySelector(".supercode-body "),a)),v()},onHide(){s.shortcut&&removeEventListener("keydown",f)}}),d.ui.registry.addButton("supercode",{icon:s.iconName,tooltip:"Source Code Editor (Ctrl + space)",onAction:x}),d.ui.registry.addMenuItem("supercode",{icon:s.iconName,text:"Source Code",onAction:x}),d.ui.registry.addContextMenu("supercode",{update:e=>"supercode"}),d.addCommand("supercode",x),s.shortcut&&d.shortcuts.add("ctrl+32","Toggles Source Code Editing Mode",x),{getMetadata:function(){return{name:"Supercode",url:"https://github.com/prathamVaidya/supercode-tinymce-plugin"}}}};tinymce.PluginManager.add("supercode",d)}();